﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Data;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Imaging;
using System.Windows.Shapes;

namespace WPF_LibrosFamosos
{
    /// <summary>
    /// Lógica de interacción para vtnEditarLibro.xaml
    /// </summary>
    public partial class vtnEditarLibro : Window
    {
        public vtnEditarLibro(CatalogoLibros cat)
        {
            InitializeComponent();
            catalogo = cat;
            
        }
        CatalogoLibros catalogo;
        libros l;
        resenhas r;

        private void btnAgregar_Click(object sender, RoutedEventArgs e)
        {
            l.Titulo = txtTitulo.Text;
            l.TituloOriginal = txtTituloOriginal.Text;
            l.Genero=txtGenero.Text;
            l.Autor = ((autores)cmbAutores.SelectedItem).IdAutor;
            r.Resenha = txtResena.Text;
            catalogo.EditarLibro(l, r);
            this.Close();
        }

        private void btnCancelar_Click(object sender, RoutedEventArgs e)
        {
            this.Close();
        }

        private void Window_Loaded(object sender, RoutedEventArgs e)
        {
            l = this.DataContext as libros;
            r = txtResena.DataContext as resenhas;
            txtTitulo.Text = l.Titulo;
            txtTituloOriginal.Text = l.TituloOriginal;
            txtGenero.Text = l.Genero;
            cmbAutores.DisplayMemberPath = "Nombre";
            cmbAutores.SelectedItem = (this.DataContext as libros).autores;
            txtResena.Text = r.Resenha;
        }
    }
}
